﻿using System;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager.EFR;
using System.Text.RegularExpressions;
using System.Web.Security.AntiXss;

public partial class DoDFragmentAnalyteDelete : BasePage
{
    private DoDFragmentManager _manager = new DoDFragmentManager();
    protected readonly string DoDFragmentPage = "DoDFragment.aspx?patientId=";
                                                 
    protected void Page_Load(object sender, EventArgs e)
    {
        HiddenFieldPatientID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["patientId"], false);
        HiddenFieldAnalyteID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["dodFragmentAnalyteId"], false);

        DOD_FRAGMENT_DETAIL analyte = _manager.GetFragmentAnalyteById(Helpers.GetIntFromString(HiddenFieldAnalyteID.Value));
        analyte.SetAsChangeTrackingRoot();
        analyte.SetAsDeleteOnSubmit();

        _manager.Update(analyte);

        ResponseRedirect(DoDFragmentPage, GetQueryStringValue(HiddenFieldPatientID.Value));
    }

    public override string TopMenuName()
    {
        return "Patients";
    }

    public override string AppObjectCode()
    {
        return "EFR_PATIENTS";
    }

    public override string MenuItemName()
    {
        return "EFR_PATIENTS";
    }

    private string GetQueryStringValue(string patientID)
    {
        string vldPatientId = string.Empty;

        if (IsQueryStringValid(patientID))
            vldPatientId = patientID.ToString();

        return vldPatientId;
    }

    private bool IsQueryStringValid(string patientID)
    {
        bool isStringValid = false;
        if (patientID != null)
        {
            if (Regex.IsMatch(patientID.ToString(), "^[a-zA-Z0-9]*$"))
            {
                isStringValid = true;
            }
        }
        return isStringValid;
    }

    private void ResponseRedirect(string destination, string queryString)
    {
        string queryStringValue = string.Empty;
        if (queryString != null)
            queryStringValue = AntiXssEncoder.UrlEncode(queryString);

        string destinationUrl = string.Concat(destination, queryStringValue);
        string currentHost = Request.Url.Host;
        if (Helpers.IsDestinationUrlLocal(destinationUrl, currentHost))
            Server.Transfer(destinationUrl);
    }
}